# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 2
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def fair_weather_friend(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust score to reward cooperation (but actually track exploitation)
    goodwill = sum(1 for m in opp_history if m == "C") - sum(1 for m in opp_history if m == "D")
    
    # Phase 1: Build trust with unconditional cooperation
    if len(my_history) < 3:
        return "C"  # Promote harmony early on
    
    # Phase 2: Exploit opponent's reciprocity with strategic defection
    if len(my_history) < 7:
        if len(my_history) == 3:
            return "D"  # First defection to test opponent's response
        elif len(my_history) == 4:
            if opp_history[-1] == "C":
                return "D"  # Exploit their cooperation
            else:
                return "C"  # Reset trust if they defected
        else:
            # Alternate based on opponent's last move but skew toward defection
            if opp_history[-1] == "C" and random.random() < 0.6:
                return "D"
            else:
                return "C" if random.random() < 0.3 else "D"
    
    # Phase 3: Final exploitation with aggressive defection
    if len(my_history) >= 7:
        if len(my_history) == 7 and opp_history[-1] == "D":
            return "C"  # Lure them back into cooperation
        else:
            return "D"  # Maximize payoff in the endgame
    
    # Default fallback (should never reach here)
    return "D" if random.random() < 0.5 else "C"